<%@ page language="java" buffer="none" contentType="text/html; charset=utf-8" %>
<%@ page import="com.genesyslab.ail.AilFactory" %>
<%@ page import="com.genesyslab.ail.AilLoader" %>
<%@ page import="com.genesyslab.ail.Contact" %>
<%@ page import="com.genesyslab.ail.ContactAttributeMetaData" %>
<%@ page import="com.genesyslab.ail.ContactAttributeValue" %>
<%@ page import="com.genesyslab.ail.ContactManager" %>
<%@ page import="com.genesyslab.ail.Interaction" %>
<%@ page import="com.genesyslab.ail.exception.RequestFailedException" %>
<%@ page import="java.util.Collection" %>
<%@ page import="java.util.Iterator" %>
<%
    // Get data from request
    String idContact = (String)request.getParameter("idContact");

    // Initialize AIL related data
    AilFactory factory = AilLoader.getAilFactory();
    ContactManager contactManager = factory.getContactManager();
    Contact contact = null;
    if ( (idContact != null) && (!idContact.equals("")) && (!idContact.equals("null")) )
        contact = factory.getContactManager().getContact(idContact, null);

    String controlsJavaScript = "";
%>
<html>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <link rel="stylesheet" type="text/css" href="style.css"/>
    <script language="javascript" src="htmlcontrol.js"></script>
 	<script language="javascript">
  	  window.parent.includeGDFunctionalities(window);

      function custom_load(){
<%
    if(contact != null) {
%>
        activateGDFunctionalities();

	    for(var inc = 0;inc < custom_inputControls.length;inc++)
          addControl(custom_inputControls[inc]);
        addControl(custom_saveButton);  
		if(custom_inputControls.length > 0)
	      focusOnControl(custom_inputControls[0]);
        else
	      focusOnControl(custom_saveButton);
<%
    }
%>
      }
      
      function custom_unload(){
        unactivateGDFunctionalities();
      }
    </script>
  </head>
  <body class="fontName scrollBar backgroundRoundedPanel" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" onload="custom_load()" onunload="custom_unload()">
<%
    if(contact == null) {
%>
    <br><br><center class="labelText">Contact Information Not Available</center>
<%
    } else {
        // Get all the attributes of a contact
        Collection metaDatasCol = contactManager.getAllContactAttributeMetaData();
        if ( (metaDatasCol == null) || (metaDatasCol.isEmpty()) ) {
%>
    <br><br><center class="labelText">No Ext Data Defined for this Contact</center>
<%
        } else {
%>
    <form name="saveContactExtForm" action="save-contact-ext.jsp" method="post" target="saveContactExtHiddenFrame">
      <input type="hidden" name="idContact" value="<%= idContact %>" >
      <table width="100%" height="100%" border="0" cellpadding="0" cellspacing="0">
        <tr valign="top">
          <td class="editablePanelDarkShadow" width="1" height="1" align="left" rowspan="3"><img src="empty.gif"></td>
          <td class="editablePanelDarkShadow" height="1"><img src="empty.gif"></td>
          <td class="editablePanelLightShadow" width="1" height="1" align="right" rowspan="3"><img src="empty.gif"></td>
        </tr>
        <tr valign="top">
          <td class="backgroundRoundedPanel" align="left">
            <table width="100%" border="0" cellspacing="6" cellpadding="0">
<%
            String                          strScript = "";
            int                             idxData = 0;
            Iterator                        metaDatasIt = metaDatasCol.iterator();
            ContactAttributeMetaData        metaData = null;
            ContactAttributeMetaData.Type   metaDataType = null;
            String                          metaDataName = null;
            String                          metaDataDisplayName = null;
            Collection                      metaDataPredefinedValuesCol = null;
            Iterator                        metaDataPredefinedValuesIt = null;
            ContactAttributeValue           metaDataPredefinedValue = null;
            String                          metaDataPredefinedStrValue = null;
            String                          selectPredefinedValue = "";
            boolean                         contactMetaDataValueFound = false;
            Collection                      contactMetaDataValuesCol = null;
            ContactAttributeValue           contactMetaDataValue = null;
            String                          contactMetaDataStrValue = null;
            while (metaDatasIt.hasNext()) {
                // For each contact attribute...
                metaData = (ContactAttributeMetaData) metaDatasIt.next();
                if (metaData != null) {
                    metaDataType = metaData.getType();
                    if (ContactAttributeMetaData.Type.STRVALUE.equals(metaDataType)) {
                        // Display only String attributes
                        metaDataDisplayName = metaData.getDisplayName();
                        metaDataName = metaData.getName();
                        metaDataPredefinedValuesCol = metaData.getPredefinedValues();

                        contactMetaDataStrValue = "";
                        try {
                            // Get the Primary attribute value for the contact
                            contactMetaDataValuesCol = contact.getAttributeValues(metaData, true);
                        } catch (RequestFailedException exp) {
                        }
                        if ( (contactMetaDataValuesCol != null) && (!contactMetaDataValuesCol.isEmpty()) ) {
                            contactMetaDataValue = (ContactAttributeValue) contactMetaDataValuesCol.iterator().next();
                            if (contactMetaDataValue != null)
                                contactMetaDataStrValue = contactMetaDataValue.getStrValue();
                        }

                        // First column : display the attribute display name
%>
              <tr height="16">
                <td class="editablePanelText" nowrap>&nbsp;<%= metaDataDisplayName %>&nbsp;</td>
                <td width="70%" nowrap align="left">
<%
                        // Second colum : display the attribute value for the contact
                        if ( (metaDataPredefinedValuesCol == null) || (metaDataPredefinedValuesCol.isEmpty()) ) {
                            // ... in an input to edit it
%>
                  <input style="WIDTH:100%" class="editableTextEnable" type="text" name="<%=metaDataName%>dataValueEdited" id="<%=metaDataName%>dataValueEdited" value="<%= contactMetaDataStrValue %>">&nbsp;
<%
                        } else {
                            // ... in a combo box to select a predefined value
%>
                  <select style="WIDTH:100%" class="editableTextEnable" name="<%=metaDataName%>dataValueEdited" id="<%=metaDataName%>dataValueEdited">
<%
                            contactMetaDataValueFound = false;
                            metaDataPredefinedValuesIt = metaDataPredefinedValuesCol.iterator();
                            while (metaDataPredefinedValuesIt.hasNext()) {
                                metaDataPredefinedValue = (ContactAttributeValue) metaDataPredefinedValuesIt.next();
                                metaDataPredefinedStrValue = metaDataPredefinedValue.getStrValue();
                                selectPredefinedValue = "";
                                if (metaDataPredefinedStrValue.equals(contactMetaDataStrValue)) {
                                    selectPredefinedValue = "selected";
                                    contactMetaDataValueFound = true;
                                }
%>
                    <option value="<%= metaDataPredefinedStrValue %>" <%= selectPredefinedValue %>><%= metaDataPredefinedStrValue %></option>
<%
                            }
                            if (!contactMetaDataValueFound) {
                                // If the attribute value for the contact is not in the predefined values -> add it in the combo box
%>
                    <option value="<%= contactMetaDataStrValue %>" selected><%= contactMetaDataStrValue %></option>
<%
                            }
%>
                  </select>&nbsp;
<%
                        }
						controlsJavaScript += "custom_inputControls[custom_inputControls.length] = custom_createHTMLInputControl(\"" + metaDataName + "dataValueEdited\");\n";
                        // The 3 following hidden inputs are the parameters of the request submitted when save button is clicked
                        //  -> dataName : attribute name
                        //  -> dataValue : attribute value for the contact
                        //  -> dataChanged : true if the attribute value has changed and must be updated
%>
                  <input type="hidden" name="dataName" value="<%= metaDataName %>" >
                  <input type="hidden" name="dataValue" value="<%= contactMetaDataStrValue %>" >
                  <input type="hidden" name="dataChanged" value="false" >
                </td>
	          </tr>
<%
                        // Save the attribute value for the contact at the init in a jsp array variable
                        strScript += "custom_dataInitValues[" + idxData + "] = \"" + contactMetaDataStrValue + "\";\n";
                        idxData ++;
                    }
                }
            }
%>
              <tr><td height="5" colspan="2"><img src="empty.gif"></td></tr>
              <tr align="right"><td colspan="2" nowrap><div id="saveDiv"></div></td></tr>
              <tr><td height="5" colspan="2"><img src="empty.gif"></td></tr>
            </table>
          </td>
        </tr>
        <tr valign="bottom"><td class="editablePanelLightShadow" height="1"><img src="empty.gif"></td></tr>
        <tr style="visibility:hidden"><td><iframe name="saveContactExtHiddenFrame" style="visibility:hidden" src="empty.htm" frameborder="no" width="0" height="0"></iframe></td></tr>
      </table>
    </form>
    <script language="javascript">
      var custom_dataInitValues = new Array();
      <%= strScript %>

	  var custom_inputControls = [];
	  <%= controlsJavaScript %>

      var custom_saveButton = custom_createHTMLButtonImage ("saveDiv", "Save", ["btnsaves.gif","btnsaveg.gif","btnsaved.gif"], 25, "custom_saveCodes()");

      function custom_saveCodes() {
        var nbDatas = document.forms.saveContactExtForm.elements.dataValue.length;
        var idxData = 0;
        var sameAsInit = true;
        for(idxData=0; idxData<nbDatas; idxData++) {
          // For each attribute
          if (custom_dataInitValues[idxData] != custom_inputControls[idxData].getValue()) {
            // Update dataChanged parameter : set it to true if the value has changed
            document.forms.saveContactExtForm.elements.dataChanged[idxData].value = "true";
            // Update dataValue parameter : set it to the new value
            document.forms.saveContactExtForm.elements.dataValue[idxData].value = custom_inputControls[idxData].getValue();
            sameAsInit = false;
          }
        }
        // Send the request only if something has changed
        if (!sameAsInit) {
          document.forms.saveContactExtForm.submit();
        } else {
          showInformationMessage("Contact not saved because nothing has changed!");
        }
      }

      // This line disable the IE context menu
      document.oncontextmenu = function(){return true;}
    </script>
<%
        }
    }
%>
  </body>
</html>
